﻿using System.Web.Mvc;
using HIPS.Web.Model.AssistedRegistration;
using HIPS.Web.ModelInterface.AssistedRegistration;
using HIPS.Web.UI;
using HIPS.Web.UI.Controllers;
using HIPS.Web.UI.ViewModels.AssistedRegistration;

namespace HIPS.Web.Test.AssistedRegistration
{
    using System;
    using System.Collections;
    using System.Collections.Generic;
    using System.Collections.Specialized;
    using System.Globalization;
    using System.Linq;
    using System.Linq.Expressions;
    using System.Threading;
    using System.Web;
    using Microsoft.VisualStudio.TestTools.UnitTesting;
    using Moq;

    namespace Test.Web
    {
        public static class MvcTestHelpers
        {
            public static void Bind<T>(this T c, Type modelType, NameValueCollection collection) where T : Controller
            {
                c.ControllerContext = c.ControllerContext ?? new ControllerContext();
                c.ControllerContext.HttpContext = RegisterValidationsTest.MockHttpContext.Create();

                ModelBindingContext modelBinder = new ModelBindingContext
                {
                    ModelMetadata = ModelMetadataProviders.Current.GetMetadataForType(null, modelType),
                    ValueProvider = new NameValueCollectionValueProvider(collection, CultureInfo.InvariantCulture)
                };
                c.ModelState.Clear();
                object binder = new DefaultModelBinder().BindModel(c.ControllerContext, modelBinder);

                c.ModelState.Merge(modelBinder.ModelState);
            }

            public static void Bind<T>(this T c, object o) where T : Controller
            {
                c.ControllerContext = c.ControllerContext ?? new ControllerContext();
                c.ControllerContext.HttpContext = RegisterValidationsTest.MockHttpContext.Create();

                ModelBindingContext modelBinder = new ModelBindingContext
                {
                    ModelMetadata = ModelMetadataProviders.Current.GetMetadataForType(() => o, o.GetType()),
                    ValueProvider = new NameValueCollectionValueProvider(new NameValueCollection(), CultureInfo.InvariantCulture)
                };
                c.ModelState.Clear();
                object binder = new DefaultModelBinder().BindModel(c.ControllerContext, modelBinder);

                c.ModelState.Merge(modelBinder.ModelState);
                //var a = ModelValidatorProviders.Providers;
                //ModelValidatorProviders.Providers.All(p => p.GetValidators());
                //ModelValidator.GetModelValidator(a.First().GetValidators()).v
            }

            public static void Bind<T, U>(this T c, RegisterValidationsTest.RequestCollection<U> o) where T : Controller
            {
                NameValueCollection collection = new NameValueCollection();
                foreach (KeyValuePair<Expression<Func<U, object>>, string> kvp in o)
                {
                    collection.Add(GetPath(kvp.Key), kvp.Value);
                }
                c.Bind(typeof(U), collection);
            }

            public static RegisterValidationsTest.TypedModelState<T> AsTyped<T>(this ModelStateDictionary m)
            {
                return new RegisterValidationsTest.TypedModelState<T>(m);
            }

            public static bool IsValidField<T>(this ModelStateDictionary m, Expression<Func<T, object>> o)
            {
                return m.IsValidField(GetPath(o));
            }

            public static string GetPath<T>(Expression<Func<T, object>> expr)
            {
                Stack<string> stack = new Stack<string>();

                MemberExpression me;
                switch (expr.Body.NodeType)
                {
                    case ExpressionType.Convert:
                    case ExpressionType.ConvertChecked:
                        UnaryExpression ue = expr.Body as UnaryExpression;
                        me = ((ue != null) ? ue.Operand : null) as MemberExpression;
                        break;
                    default:
                        me = expr.Body as MemberExpression;
                        break;
                }

                while (me != null)
                {
                    stack.Push(me.Member.Name);
                    me = me.Expression as MemberExpression;
                }

                return string.Join(".", stack.ToArray());
            }
        }

        [TestClass]
        public class RegisterValidationsTest
        {
            private DefaultModelBinder binder;
            private ControllerContext controllerContext;

            [TestInitialize]
            public void Setup()
            {
                Thread.CurrentThread.CurrentUICulture = new CultureInfo("en-AU");
                DataAnnotationsModelValidatorProvider.AddImplicitRequiredAttributeForValueTypes = false;
                binder = new DefaultModelBinder();
                controllerContext = new ControllerContext { HttpContext = MockHttpContext.Create() };

                using (MvcApplication m = new MvcApplication())
                {
                    m.RegisterValidatorProviders();
                }
            }

            [TestCleanup]
            public void Teardown()
            {
                //Cleanup
            }

            protected ModelMetadata CreateMetaData(Type type)
            {
                DataAnnotationsModelMetadataProvider meta = new DataAnnotationsModelMetadataProvider();
                return meta.GetMetadataForType(null, type);
            }

            public class MockHttpContext : Mock<HttpContextBase>
            {
                public MockHttpContext()
                {
                    Setup(x => x.Items).Returns(new Hashtable());
                }

                public static HttpContextBase Create()
                {
                    return new MockHttpContext().Object;
                }
            }

            public class RequestCollection<T> : Dictionary<Expression<Func<T, object>>, string>
            {
            }

            public class TypedModelState<T>
            {
                public ModelStateDictionary ModelStateDictionary;

                public TypedModelState(ModelStateDictionary modelStateDictionary)
                {
                    ModelStateDictionary = modelStateDictionary;
                }

                public void Bind(Controller c, T obj)
                {
                    c.Bind(obj);
                }

                public void Bind(Controller c, RequestCollection<T> obj)
                {
                    NameValueCollection collection = new NameValueCollection();
                    foreach (KeyValuePair<Expression<Func<T, object>>, string> kvp in obj)
                    {
                        collection.Add(GetPath(kvp.Key), kvp.Value);
                    }
                    c.Bind(typeof(T), collection);
                }

                public bool IsValidField(Expression<Func<T, object>> obj)
                {
                    return ModelStateDictionary.IsValidField(GetPath(obj));
                }

                public static string GetPath(Expression<Func<T, object>> expr)
                {
                    Stack<string> stack = new Stack<string>();

                    MemberExpression me;
                    switch (expr.Body.NodeType)
                    {
                        case ExpressionType.Convert:
                        case ExpressionType.ConvertChecked:
                            UnaryExpression ue = expr.Body as UnaryExpression;
                            me = ((ue != null) ? ue.Operand : null) as MemberExpression;
                            break;
                        default:
                            me = expr.Body as MemberExpression;
                            break;
                    }

                    while (me != null)
                    {
                        stack.Push(me.Member.Name);
                        me = me.Expression as MemberExpression;
                    }

                    return string.Join(".", stack.ToArray());
                }
            }

            public RegisterViewModel ValidRegisterWithRepresentativeViewModel = new RegisterViewModel
            {
                Applicant =
                    new PersonDemographicViewModel
                    {
                        FamilyName = "TestFamilyName",
                        GivenNames = "TestGivenName",
                        DateOfBirth = DateTime.Now.AddYears(-12),
                        DvaFileNumber = "12345",
                        SexCode = "1"
                    },
                Representative =
                    new PersonDemographicViewModel
                    {
                        FamilyName = "TestFamilyName",
                        GivenNames = "TestGivenName",
                        DateOfBirth = DateTime.Now.AddYears(-30),
                        DvaFileNumber = "12345",
                        SexCode = "1"
                    },
                ConsentDeclared = true,
                IdentityVerificationMethod = "Test",
                IvcDeliveryMethod = "Test",
                //MedicareInformationAccessIds = new[] { "Test" }
            };

            [TestMethod]
            public void InvalidDataTypesBindingErrorTest()
            {
                // Disabled for now due to IOC change
            //    // Setup
            //    AssistedRegistrationController r = new AssistedRegistrationController();

            //    // Verify Defaults
            //    r.Bind(ValidRegisterWithRepresentativeViewModel);
            //    TypedModelState<RegisterViewModel> ms = r.ModelState.AsTyped<RegisterViewModel>();

            //    Assert.IsTrue(ms.IsValidField(a => a.Applicant.SexCode));
            //    Assert.IsTrue(ms.IsValidField(a => a.Applicant.IndigenousStatusCode));
            //    Assert.IsTrue(ms.IsValidField(a => a.Representative.SexCode));
            //    Assert.IsTrue(ms.IsValidField(a => a.Representative.IndigenousStatusCode));
            //    Assert.IsTrue(ms.IsValidField(a => a.ConsentDeclared));

            //    // Test
            //    r.Bind(new RequestCollection<RegisterViewModel>
            //    {
            //        { a => a.Applicant.SexCode, "Test" },
            //        { a => a.Applicant.IndigenousStatusCode, "Test" },
            //        { a => a.Representative.SexCode, "Test" },
            //        { a => a.Representative.IndigenousStatusCode, "Test" },
            //        { a => a.ConsentDeclared, "Test" },
            //    });
            //    ms = r.ModelState.AsTyped<RegisterViewModel>();

            //    Assert.IsFalse(ms.IsValidField(a => a.Applicant.SexCode));
            //    Assert.IsFalse(ms.IsValidField(a => a.Applicant.IndigenousStatusCode));
            //    Assert.IsFalse(ms.IsValidField(a => a.Representative.SexCode));
            //    Assert.IsFalse(ms.IsValidField(a => a.Representative.IndigenousStatusCode));
            //    Assert.IsFalse(ms.IsValidField(a => a.ConsentDeclared));
            }
        }

        public class MockARReferenceRepository : IAssistedRegistrationReferenceRepository
        {
            public List<IdentityVerificationMethod> GetIdentityVerificationMethods()
            {
                return new[] { new IdentityVerificationMethod { Code = "Test", Description = "Test2" } }.ToList();
            }

            public List<IndigenousStatus> GetIndigenousStatuses()
            {
                return new[] { new IndigenousStatus { Code = "Test", Description = "Test2" } }.ToList();
            }

            public List<IvcDeliveryMethod> GetIvcDeliveryMethods()
            {
                return new[] { new IvcDeliveryMethod { Code = "Test", Description = "Test2" } }.ToList();
            }

            public List<MedicareConsent> GetMedicareConsents()
            {
                return new[] { new MedicareConsent { Code = "Test", Description = "Test2" } }.ToList();
            }

            public List<Sex> GetSexes()
            {
                return new[] { new Sex { Code = "Test", Description = "Test2" } }.ToList();
            }

            public void Dispose()
            {
                // Do Nothing
            }
        }
    }
}
